<?php

namespace App\Models;

use Illuminate\Contracts\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Pesan extends Model
{
    use HasFactory;
    protected $fillable = [
        'nama',
        'email',
        'subjek',
        'pesan',
        'sts_pesan',
    ];

    public function scopePencarian(Builder $query): void
    {
        $query->where('nama', 'like', '%' . request('cari') . '%')
            ->orwhere('email', 'like', '%' . request('cari') . '%')
            ->orwhere('subjek', 'like', '%' . request('cari') . '%');
    }
}
